CREATE TABLE oik.oik_doc
(
    id       uuid     not null
        constraint oik_doc_pkey
            primary key,
    doc_type smallint not null,
    name     text     not null,
    user_id  integer,
    group_id integer
);

ALTER TABLE oik.oik_doc
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc TO postgres;


create table oik.oik_doc_pdf
(
    id                uuid not null
        constraint oik_doc_pdf_pkey
            primary key,
    content           bytea,
    original_filename text
);

ALTER TABLE oik.oik_doc_pdf
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc_pdf TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc_pdf TO postgres;


create table oik.oik_doc_report
(
    id                uuid not null
        constraint oik_doc_report_pkey
            primary key,
    content           bytea,
    specialty         integer,
    original_filename text
);

ALTER TABLE oik.oik_doc_report
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc_report TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc_report TO postgres;


create table oik.oik_doc_scheme
(
    id                uuid    not null
        constraint oik_doc_sch_pkey
            primary key,
    scheme_id         integer not null,
    content_xsde      xml,
    content_json      json,
    original_filename text
);

ALTER TABLE oik.oik_doc_scheme
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc_scheme TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc_scheme TO postgres;


create table oik.oik_doc_svg
(
    id                uuid not null
        constraint oik_doc_svg_pkey
            primary key,
    content           bytea,
    original_filename text
);

ALTER TABLE oik.oik_doc_svg
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc_svg TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc_svg TO postgres;

	
create table oik.oik_doc_web_dashboard
(
    id                uuid not null
        constraint oik_doc_web_dashboard_pkey
            primary key,
    content           bytea,
    original_filename text
);

ALTER TABLE oik.oik_doc_web_dashboard
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc_web_dashboard TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc_web_dashboard TO postgres;


create table oik.oik_doc_tags
(
    tag    text not null,
    doc_id uuid not null,
    constraint oik_doc_tags_pk
        primary key (tag, doc_id)
);

ALTER TABLE oik.oik_doc_tags
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc_tags TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc_tags TO postgres;


create table oik.oik_doc_excel_dashboard
(
    id                uuid not null
        constraint oik_doc_excel_dashboard_pkey
            primary key,
    content           bytea,
    original_filename text
);

ALTER TABLE oik.oik_doc_excel_dashboard
    OWNER to postgres;

GRANT SELECT ON TABLE oik.oik_doc_excel_dashboard TO oik_group_super;
GRANT ALL ON TABLE oik.oik_doc_excel_dashboard TO postgres;
